/*

 BinaryStream Class for C++
 (c) 2004 Jonathan Bettencourt / Kreative Korporation

 This imitates the BinaryStream class from RealBasic.
 You create a BinaryStream class from a certain file, and
 you can do random access and read and write stuff.

 The methods for reading and writing are similar to the
 methods for getting and setting things in a memoryblock.

 Sorry the documentation on this one isn't as nicely done
 as on MemoryBlock, but whatever.


 This code is under the MIT license.

 Permission is hereby granted, free of charge, to any person obtaining a copy of
 this software and associated documentation files (the "Software"), to deal in the
 Software without restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
 Software, and to permit persons to whom the Software is furnished to do so,
 subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies
 or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#ifndef _____BINARYSTREAM_____
#define _____BINARYSTREAM_____

#include <string>
#include <fstream>
#include <iostream>
using namespace std;

class binarystream
{
	public:

	enum binarystream_exception { notOpen, alreadyOpen, openFailed, genericException };

	bool littleEndian;

	binarystream(void); /* default const */
	binarystream(char *, bool, bool); /* basic const */
	binarystream(const string &, bool, bool);
	/* binarystream(const binarystream&); copier */
	~binarystream(void); /* destructor */
	/* const binarystream& operator = (const binarystream&); assign */

	void open(const char *, bool, bool);
	void open(const string &, bool, bool);
	void close(void);
	char * read(int);
	void write(char *, int);
	void write(string, int);

	bool eof(void);
	bool ok(void);
	void reset(void);
	unsigned long int getLength(void);
	void setLength(unsigned long int);
	unsigned long int getPosition(void);
	void setPosition(unsigned long int);
	fstream& getFStream(void);

	void setLittleEndian(void);
	void setBigEndian(void);
	void setMotorola(void);
	void setIntel(void);
	void setDefaultEndianness(void);

	/* REALBASIC-LIKE READ/WRITE FUNCTIONS */
	bool readBooleanValue(void);
	int readByte(void);
	char * readCString(void);
	string readCStringAsString(void);
	double readDoubleValue(void);
	int readLong(void);
	char * readPString(void);
	char * readPStringAsCString(void);
	string readPStringAsString(void);
	int readShort(void);
	double readSingleValue(void);
	char * readStringValue(int);
	char * readStringValueAsCString(int);
	string readStringValueAsString(int);
	int readUShort(void);

	void writeBooleanValue(bool);
	void writeByte(int);
	void writeCString(const char*);
	void writeCStringAsString(string);
	void writeDoubleValue(double);
	void writeLong(int);
	void writePString(char*);
	void writePStringAsCString(char*);
	void writePStringAsString(string);
	void writeShort(int);
	void writeSingleValue(double);
	void writeStringValue(int, char*);
	void writeStringValueAsCString(int, char*);
	void writeStringValueAsString(int, string);
	void writeUShort(int);

	/* C++-LIKE READ/WRITE FUNCTIONS */
	bool readBool(void);
	char readChar(void);
	signed char readSignedChar(void);
	int readInt(void);
	short int readShortInt(void);
	long int readLongInt(void);
	unsigned short int readUnsignedShortInt(void);
	unsigned long int readUnsignedLongInt(void);
	float readFloat(void);
	double readDouble(void);
	long double readLongDouble(void);
	wchar_t readWchar_t(void);
	string readString(void);
	char * readCharStar(void);

	void writeBool(bool);
	void writeChar(char);
	void writeSignedChar(signed char);
	void writeInt(int);
	void writeShortInt(short int);
	void writeLongInt(long int);
	void writeUnsignedShortInt(unsigned short int);
	void writeUnsignedLongInt(unsigned long int);
	void writeFloat(float);
	void writeDouble(double);
	void writeLongDouble(long double);
	void writeWchar_t(wchar_t);
	void writeString(string);
	void writeCharStar(char *);

	private:

	fstream mystream;
	char * savefname;
	bool savewritacc;
	unsigned long int mypos;
	bool isopen;

	int min(int, int);
	int max(int, int);

	//CONVERSION UNION
	/* We need this to convert from one type of value to another,
	because (char *)&value obviously doesn't work. */

	union bconverter
	{
		bool boolv;
		char charv[sizeof(long double)];
		signed char scharv;
		int intv;
		short int sintv;
		long int lintv;
		unsigned short int usintv;
		unsigned long int ulintv;
		float floatv;
		double doublev;
		long double ldoublev;
		char charv2;
		wchar_t wchartv;
	};
};

inline int binarystream::min(int x, int y)
{
	return (x>y)?y:x;
}

inline int binarystream::max(int x, int y)
{
	return (x>y)?x:y;
}

inline void binarystream::setLittleEndian(void)
{
	littleEndian = true;
}

inline void binarystream::setBigEndian(void)
{
	littleEndian = false;
}

inline void binarystream::setMotorola(void)
{
	littleEndian = false;
}

inline void binarystream::setIntel(void)
{
	littleEndian = true;
}

#endif